\version "2.24.0"
\language "deutsch"

\paper {
  %between-system-padding = 0\mm
  %markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ca pe Împăratul"
  subtitle = "glasul 8"
  composer = "Armonizat după N. Lungu"
  meter = "Moderato"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOn
}

womenWords = \lyricmode {
  Ca pe Îm -- pă -- ra -- tul tu -- tu -- ror __ pri -- mind,
  pe Îm -- pă -- ra -- tul, Îm -- pă -- ra -- tul
  tu -- tu -- ror __ pri -- mind

  pe cel __ ne -- vă -- zut __ în -- con -- ju -- rat __
  de ce -- te -- le în -- ge -- reşti. __

  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a.
}

menWords = \lyricmode {
  Ca pe Îm -- pă -- ra -- tul tu -- tu -- ror pri -- mind,
  pe 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1
  cel ne -- vă -- zut în -- con -- ju -- rat __ 
  
  de ce -- te -- le în -- ge -- reşti. __

  A -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a.
}

sopMusic = \relative c' {
  % Ca pe Împăratul tuturor primind
  f4.^\mf g8
  a4 b4
  c4( d4)
  c2
  d4 d4
  e8([ f8 e8 d8)]
  e4.( f8)
  f4. \breathe

  % pe Împăratul, Împăratul tuturor primind
  c8^\p
  c4 c4
  d4 c8( b8)
  a4 g8( a8)
  f4 f4
  g4 a8( b8)
  a4( g4)
  f4( e4)
  f4. \breathe

  % pe cel nevăzut înconjurat
  g8
  a4.( b8)
  a4 b4
  c4.( d8
  c4) \breathe b4
  a8( g8 a4)
  b8( c8 b4)
  c2~
  c4

  % de cetele îngereşti.
  c4
  d2
  d4 d4
  e8([ f8 e8 d8)]
  e4.( f8)
  f2~
  f4 b,4\rest

  % Aliluia, aliluia, aliluia.
  f4 g4
  b8( a8 g4)
  a4( b4)
  c2
  b4 a4
  d4( c4)
  b4( c4)
  a2
  f4 g4
  a8([ b8 a8 f8)]
  g4.( a8)
  f2 ^\fermata \bar "|."
}

altMusic = \relative c' {
  % Ca pe Împăratul tuturor primind
  f4. g8
  a4 b4
  c4( d4)
  c2
  b4 g4
  c2
  c4( b4)
  a4.

  % pe Împăratul, Împăratul tuturor primind
  a8
  a4 a4
  b4 a8( g8)
  f4 e4
  f4 f4
  e4 f8( g8)
  f4( e4)
  f4( e4)
  f4.

  % pe cel nevăzut înconjurat
  e8
  f4.( g8)
  f4 g4
  a4.( b8
  a4) g4
  f8( e8 f4)
  g8( a8 g4)
  a2~
  a4

  % de cetele îngereşti.
  a4
  b2
  b4 g4
  c2
  c4( b4)
  a2~
  a4 b4\rest

  % Aliluia, aliluia, aliluia.
  f4 g4
  b8( a8 g4)
  f4( g4)
  a2
  g4 f4
  b4( a4)
  g4( a4)
  f2
  f4 g4
  f2
  e2
  f2
}

tenorMusic = \relative c {
  d2\rest d2\rest c'8. c16 d8 d c4 c b4 b4 c2 c2 c4.
  c8 c4 c4 b4 c8( d8) c4 c c c c c c( b) a( g) f4.
  d8\rest d2\rest d2\rest d8\rest  
  a'8 c b a4 b4 c2 c c2~ c4
  c4 d2 d4 d c2 c c2~ c4 d,4\rest
  d2\rest f4 g a a a2
  d,2\rest c'4 c d c c2
  d,2\rest c'4 c c b a2
}

bassMusic = \relative c {
  d2\rest d2\rest c'8. a16 g8 f c'4 c b g c2 c, f4.
  f8 f4 f b a8( g) f4 c f f c c c2 c f4.
  d8\rest d2\rest d2\rest d8\rest  
  a'8 a b a4 g4 f8( e8 f4) c4( d8[ e]) f2( f4)
  f4 b2 b4 g c2 c, f2~ f4 d4\rest
  d2\rest f4 g f f f2
  d2\rest d4 c f f f2
  d2\rest f4 f c c <f f,>2
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 90
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}


\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}